/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.item;

import com.yuushya.item.AbstractMultiPurposeToolItem;
import com.yuushya.utils.YuushyaUtils;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureCreatorItem
extends AbstractMultiPurposeToolItem {
    private final ResourceLocation createNbt;
    private final ResourceLocation cancelNbt;
    private Vec3i size;
    private BlockPos pos;
    private int _rot = 0;
    private int _mirror = 0;
    private int _offsetX = 0;
    private int _offsetZ = 0;

    private void changeIntMirror() {
        if (++this._mirror > 2) {
            this._mirror = 0;
        }
    }

    private void changeIntRotation() {
        if (++this._rot > 3) {
            this._rot = 0;
        }
    }

    public StructureCreatorItem(Item.Properties properties, Integer tipLines, String createNbt, String cancelNbt) {
        super(properties, tipLines);
        this.MAX_FORMS = 4;
        this.createNbt = createNbt != null ? ResourceLocation.m_135820_((String)createNbt) : null;
        this.cancelNbt = cancelNbt != null ? ResourceLocation.m_135820_((String)cancelNbt) : null;
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        if (level.f_46443_ || player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos1 = blockPos.m_5487_(Direction.Axis.Y, 1);
        this.getTag(handItemStack);
        if (this.getForm() == 0) {
            if (this.createNbt == null) {
                return InteractionResult.CONSUME;
            }
            this.pos = new BlockPos((Vec3i)pos1);
            this.loadStructure((ServerLevel)level, this.createNbt, this.pos, handItemStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult inMainHandRightClickInAir(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        if (level.f_46443_ || player == null) {
            return InteractionResult.PASS;
        }
        switch (this.getForm()) {
            case 1: {
                if (this.createNbt == null) {
                    return InteractionResult.PASS;
                }
                if (this.cancelNbt == null) {
                    this.setAir((ServerLevel)level, this.createNbt);
                    break;
                }
                this.loadStructure((ServerLevel)level, this.cancelNbt, this.pos, handItemStack);
                break;
            }
            case 2: 
            case 3: {
                if (this.getForm() == 2) {
                    this.changeIntMirror();
                } else {
                    this.changeIntRotation();
                }
                this.setTag(handItemStack);
                player.m_5661_((Component)Component.m_237110_((String)"item.yuushya.structure_creator.show", (Object[])new Object[]{Mirror.values()[this._mirror].toString(), Rotation.values()[this._rot].toString()}), true);
                break;
            }
            default: {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inOffHandRightClickInAir(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        this.changeForm();
        this.setTag(handItemStack);
        player.m_5661_((Component)Component.m_237115_((String)("item.yuushya.structure_creator." + this.getForm())), true);
        return InteractionResult.PASS;
    }

    public boolean loadStructure(ServerLevel serverLevel, ResourceLocation structureName, BlockPos blockPos, ItemStack itemStack) {
        if (structureName != null) {
            StructureTemplateManager structureManager = serverLevel.m_215082_();
            try {
                Optional structure2 = structureManager.m_230407_(structureName);
                Vec3i size = ((StructureTemplate)structure2.get()).m_163801_();
                this.size = new Vec3i(size.m_123341_(), size.m_123342_(), size.m_123343_());
                this.setTag(itemStack);
                BlockPos blockPos1 = this.getOffset(this.pos);
                return this.place(serverLevel, (StructureTemplate)structure2.get(), blockPos1);
            }
            catch (ResourceLocationException var6) {
                return false;
            }
        }
        return false;
    }

    public boolean place(ServerLevel serverLevel, StructureTemplate structure, BlockPos blockPos) {
        StructurePlaceSettings structurePlacementData = new StructurePlaceSettings().m_74377_(Mirror.values()[this._mirror]).m_74379_(Rotation.values()[this._rot]);
        structure.m_230328_((ServerLevelAccessor)serverLevel, blockPos, blockPos, structurePlacementData, serverLevel.m_213780_(), 2);
        return true;
    }

    public boolean setAir(ServerLevel serverLevel, ResourceLocation structureName) {
        if (this.pos == null || this.size == null) {
            return false;
        }
        BlockPos blockPos = this.getOffset(this.pos);
        int i = 0;
        while (Math.abs(i) <= this.size.m_123341_()) {
            int j = 0;
            while (Math.abs(j) <= this.size.m_123343_()) {
                for (int k = 0; k < this.size.m_123342_(); ++k) {
                    BlockPos blockPos1 = new BlockPos(i + blockPos.m_123341_(), k + blockPos.m_123342_(), j + blockPos.m_123343_());
                    serverLevel.m_7731_(blockPos1, Blocks.f_50016_.m_49966_(), 3);
                }
                j = this._offsetZ < 0 ? j - 1 : j + 1;
            }
            i = this._offsetX < 0 ? i - 1 : i + 1;
        }
        this.pos = null;
        return true;
    }

    @Override
    public void getTag(ItemStack itemStack) {
        super.getTag(itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        ListTag listTag = compoundTag.m_128437_("Pos", 6);
        ListTag listTag1 = compoundTag.m_128437_("Size", 6);
        this.pos = new BlockPos(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
        this.size = new Vec3i(listTag1.m_128772_(0), listTag1.m_128772_(1), listTag1.m_128772_(2));
        this._rot = compoundTag.m_128451_("rotation");
        this._mirror = compoundTag.m_128451_("mirror");
    }

    @Override
    public void setTag(ItemStack itemStack) {
        super.setTag(itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128365_("Pos", (Tag)YuushyaUtils.toListTag(this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()));
        compoundTag.m_128365_("Size", (Tag)YuushyaUtils.toListTag(this.size.m_123341_(), this.size.m_123342_(), this.size.m_123343_()));
        compoundTag.m_128405_("rotation", this._rot);
        compoundTag.m_128405_("mirror", this._mirror);
        itemStack.m_41751_(compoundTag);
    }

    private BlockPos getOffset(BlockPos blockPos) {
        block0 : switch (this._mirror) {
            case 0: {
                switch (this._rot) {
                    case 0: {
                        this._offsetX = 1;
                        this._offsetZ = 1;
                        break;
                    }
                    case 1: {
                        this._offsetX = -1;
                        this._offsetZ = 1;
                        break;
                    }
                    case 2: {
                        this._offsetX = -1;
                        this._offsetZ = -1;
                        break;
                    }
                    case 3: {
                        this._offsetX = 1;
                        this._offsetZ = -1;
                    }
                }
                break;
            }
            case 1: {
                switch (this._rot) {
                    case 0: {
                        this._offsetX = 1;
                        this._offsetZ = -1;
                        break;
                    }
                    case 1: {
                        this._offsetX = 1;
                        this._offsetZ = 1;
                        break;
                    }
                    case 2: {
                        this._offsetX = -1;
                        this._offsetZ = 1;
                        break;
                    }
                    case 3: {
                        this._offsetX = -1;
                        this._offsetZ = -1;
                    }
                }
                break;
            }
            case 2: {
                switch (this._rot) {
                    case 0: {
                        this._offsetX = -1;
                        this._offsetZ = 1;
                        break block0;
                    }
                    case 1: {
                        this._offsetX = -1;
                        this._offsetZ = -1;
                        break block0;
                    }
                    case 2: {
                        this._offsetX = 1;
                        this._offsetZ = -1;
                        break block0;
                    }
                    case 3: {
                        this._offsetX = 1;
                        this._offsetZ = 1;
                    }
                }
            }
        }
        blockPos = blockPos.m_5487_(Direction.Axis.X, -this._offsetX * this.size.m_123341_() / 2);
        blockPos = blockPos.m_5487_(Direction.Axis.Z, -this._offsetZ * this.size.m_123343_() / 2);
        return blockPos;
    }
}

